import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/date_converter.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/transaction/transaction_history_controller.dart';
import 'package:viserpay_agent/view/components/column_widget/card_column.dart';

class TransactionCard extends StatelessWidget {
  final int index;
  final VoidCallback press;
  const TransactionCard({super.key, required this.index, required this.press});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<TransactionHistoryController>(builder: (controller) {
      return GestureDetector(
        onTap: press,
        child: Container(
          width: MediaQuery.of(context).size.width,
          padding: const EdgeInsets.symmetric(vertical: Dimensions.space15, horizontal: Dimensions.space10),
          decoration: BoxDecoration(
            color: MyColor.getCardBgColor(),
          ),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: Row(
                  children: [
                    Container(
                      height: 35,
                      width: 35,
                      alignment: Alignment.center,
                      child: Container(
                        height: 35,
                        width: 35,
                        decoration: BoxDecoration(
                          color: controller.transactionList[index].trxType == "-" ? MyColor.colorRed.withOpacity(0.2) : MyColor.colorGreen.withOpacity(0.2),
                          shape: BoxShape.circle,
                        ),
                        child: Icon(
                          controller.transactionList[index].trxType == "-" ? Icons.arrow_upward : Icons.arrow_downward,
                          color: controller.transactionList[index].trxType == "-" ? MyColor.colorRed : MyColor.colorGreen,
                          size: 20,
                        ),
                      ),
                    ),
                    const SizedBox(width: Dimensions.space10),
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            "${controller.transactionList[index].remark}".replaceAll("_", " ").toTitleCase().tr,
                            style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w500),
                            maxLines: 1,
                            overflow: TextOverflow.ellipsis,
                          ),
                          const SizedBox(height: Dimensions.space5),
                          SizedBox(
                            width: 150,
                            child: Text(
                              controller.transactionList[index].trx.toString(),
                              style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.5)),
                              overflow: TextOverflow.ellipsis,
                              maxLines: 2,
                            ),
                          )
                        ],
                      ),
                    )
                  ],
                ),
              ),
              Expanded(
                child: CardColumn(
                  header: "${controller.transactionList[index].trxType}${controller.currencySym}${Converter.formatNumber(controller.transactionList[index].amount.toString())}",
                  body: DateConverter.formatDateMonthYear(controller.transactionList[index].createdAt.toString()),
                  alignmentEnd: true,
                  headerTextDecoration: boldDefault.copyWith(
                    color: controller.transactionList[index].trxType == "-" ? MyColor.colorRed : MyColor.colorGreen,
                    fontSize: Dimensions.fontMediumLarge - 1,
                    fontWeight: FontWeight.w500,
                  ),
                  bodyTextDecoration: lightMediumLarge.copyWith(color: MyColor.colorGrey, fontSize: Dimensions.fontDefault - 1),
                ),
              )
            ],
          ),
        ),
      );
    });
  }
}
